local function PercentScore(pn)
local t = LoadFont("Common Normal")..{
	InitCommand=function(self) self:horizalign(center):diffuse(ColorLightTone(PlayerColor(pn))) end;
	BeginCommand=function(self) self:playcommand("Set") end;
	SetCommand=function(self)
		local SongOrCourse, StepsOrTrail;
		if GAMESTATE:IsCourseMode() then
			SongOrCourse = GAMESTATE:GetCurrentCourse();
			StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
		else
			SongOrCourse = GAMESTATE:GetCurrentSong();
			StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
		end;

		local profile, scorelist;
		local text = "";
		if SongOrCourse and StepsOrTrail then
			if PROFILEMAN:IsPersistentProfile(pn) then
				-- player profile
				profile = PROFILEMAN:GetProfile(pn);
			else
				-- machine profile
				profile = PROFILEMAN:GetMachineProfile();
			end;

			scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
			assert(scorelist)
			local scores = scorelist:GetHighScores();
			local topscore = scores[1];
			if topscore then
				text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
				-- 100% hack
				if text == "100.00%" then
					text = "100%";
				end;
			else
				text = string.format("%.2f%%", 0);
			end;
		else
			text = "";
		end;
		self:settext(text);
	end;
	CurrentSongChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentCourseChangedMessageCommand=function(self) self:playcommand("Set") end;
	};

	if pn == PLAYER_1 then
		t.CurrentStepsP1ChangedMessageCommand=function(self) self:playcommand("Set") end;
		t.CurrentTrailP1ChangedMessageCommand=function(self) self:playcommand("Set") end;
	else
		t.CurrentStepsP2ChangedMessageCommand=function(self) self:playcommand("Set") end;
		t.CurrentTrailP2ChangedMessageCommand=function(self) self:playcommand("Set") end;
	end

	return t;
end;
local t = Def.ActorFrame {};
-- Panel
t[#t+1] = LoadActor(THEME:GetPathG("ScreenWithMenuElements", "sidepanel")) .. {
	InitCommand=function(self)
			self:horizalign(right):x(SCREEN_CENTER_X-319)
		end;
	OnCommand=function(self)
		self:addx(-SCREEN_WIDTH):decelerate(0.6):addx(SCREEN_WIDTH)
	end;	
	OffCommand=function(self)
		self:decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
};	

t[#t+1] = Def.Sprite {
	Texture="_banner";
	InitCommand=function(self)
		self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y-150)
	end;
	OnCommand=function(self)
		self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH)
	end;		
	OffCommand=function(self)
		self:decelerate(0.6):addx(SCREEN_WIDTH)
	end;
	};
	
t[#t+1] = Def.Sprite {
	Texture="_banglow";
	InitCommand=function(self) 
		self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y-150)
		self:blend('add') 
	end;
	OnCommand=function(self) 
		self:diffuseshift():effectperiod(3):effectcolor1(1,1,1,0):effectcolor2(1,1,1,0.7) 
		self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
	OffCommand=function(self)
		self:decelerate(0.6):addx(SCREEN_WIDTH)
	end;
};

-- Artist
t[#t+1] = LoadFont("Common Normal") .. {
	InitCommand=function(self) self:horizalign(left):x(SCREEN_CENTER_X+30):y(SCREEN_CENTER_Y-82):diffuse(color("#F7E16E")):zoom(0.6):maxwidth(222/0.6) end;
	OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) end;		
	OffCommand=function(self) self:decelerate(0.6):addx(SCREEN_WIDTH) end;
	CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
	CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
	ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
	SetCommand=function(self)
		if not GAMESTATE:IsCourseMode() then
		   if GAMESTATE:GetCurrentSong() then
				if GAMESTATE:GetCurrentSong():GetDisplayArtist() then
					self:settext(GAMESTATE:GetCurrentSong():GetDisplayArtist()):playcommand("Refresh");
				end;
			else
				self:settext(" "):playcommand("Refresh");
			end;
		else
		local course = GAMESTATE:GetCurrentCourse(); 
		   if course then
				self:settext(CourseTypeToLocalizedString(course:GetCourseType())); 
				self:queuecommand("Refresh");
			else
				self:settext("");
				self:queuecommand("Refresh"); 	
		   end
		end;
	end;
	};
	
-- Genre or Course Length
t[#t+1] = LoadFont("Common Normal") .. {
	InitCommand=function(self) self:horizalign(left):x(SCREEN_CENTER_X+30):y(SCREEN_CENTER_Y-66):diffuse(color("#FFFFFF")):zoom(0.5):maxwidth(222/0.5) end;
	OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) end;		
	OffCommand=function(self) self:decelerate(0.6):addx(SCREEN_WIDTH) end;
	CurrentSongChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
	CurrentCourseChangedMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
	ChangedLanguageDisplayMessageCommand=function(self) self:finishtweening():playcommand("Set") end;
	SetCommand=function(self)
	if not GAMESTATE:IsCourseMode() then
		   if GAMESTATE:GetCurrentSong() then
				if GAMESTATE:GetCurrentSong():GetGenre() then
					self:settext(GAMESTATE:GetCurrentSong():GetGenre()):diffusealpha(1):playcommand("Refresh");
				end;
			else
				self:settext("")
			end;
		else
			local course = GAMESTATE:GetCurrentCourse();
			if course then
				self:settext(course:GetEstimatedNumStages() .. " songs");
			else
				self:settext("");
			end 
		end; 
	end;
	};
	
-- BPM and Time;
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if GAMESTATE:IsCourseMode() then
			curSelection = GAMESTATE:GetCurrentCourse();
			self:playcommand("Reset");
			if curSelection then
				local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
				if trail then
					length = TrailUtil.GetTotalSeconds(trail);
				else
					length = 0.0;
				end;
			else
				length = 0.0;
			end;
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
		end;
		self:settext( SecondsToMSS(length) );
	end;
	CurrentSongChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentCourseChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentTrailP1ChangedMessageCommand=function(self) self:playcommand("Set") end;
	CurrentTrailP2ChangedMessageCommand=function(self) self:playcommand("Set") end;
	};

if not GAMESTATE:IsCourseMode() then
t[#t+1] = Def.ActorFrame {
	InitCommand=function(self)
		self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y+154-4)
	end;
	OnCommand=function(self)
		self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
	OffCommand=function(self)
		self:decelerate(0.6):addx(SCREEN_WIDTH)
	end;
	Def.Sprite {
		Texture="_difficulty";
	};
	Def.Sprite {
		Texture="_diffglow";
		InitCommand=function(self) self:blend('add') end;
		OnCommand=function(self) self:diffuseshift():effectperiod(3):effectcolor1(1,1,1,0):effectcolor2(1,1,1,0.7) end;
		};
	};
else
t[#t+1] = StandardDecorationFromFileOptional("CourseContentsList","CourseContentsList");
end;

t[#t+1] = Def.Quad {
	InitCommand=function(self)
		self:zoomto(320,2):fadeleft(0.6):faderight(0.6):diffuse(color("#0BD2A1"))
		self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y-50)
	end;
	OnCommand=function(self)
		self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
	OffCommand=function(self)
		self:decelerate(0.6):addx(SCREEN_WIDTH)
	end;
};

t[#t+1] = Def.Quad {
	InitCommand=function(self)
		self:visible(GAMESTATE:IsCourseMode())
		self:zoomto(320,2):fadeleft(0.6):faderight(0.6):diffuse(color("#0BD2A1"))
		self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y+78)
	end;
	OnCommand=function(self)
		self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH)
	end;
	OffCommand=function(self)
		self:decelerate(0.6):addx(SCREEN_WIDTH)
	end;
};
	
t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");

-- Player Pods
for pn in ivalues(PlayerNumber) do
local icon_offset = string.find(pn, "P1") and -70 or 70
if GAMESTATE:IsCourseMode() == false then
	t[#t+1] = StandardDecorationFromTable("PercentScore"..ToEnumShortString(pn), PercentScore(pn));	
	t[#t+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:visible(GAMESTATE:IsHumanPlayer(pn))
		end;
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == (pn) then
				self:visible(true):diffusealpha(0):decelerate(0.2):diffusealpha(1)
			end;
		end;
		OffCommand=function(self) self:decelerate(0.6):addx(SCREEN_WIDTH) end;
		---
		Def.Sprite {
			Texture="_diffring.png";
			InitCommand=function(self) self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y+4):addx(icon_offset):diffuse(PlayerColor(pn))
			end;
			OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) 
				self:spin():effectmagnitude(0,0,26)
			end;
		};		
		Def.Sprite {
			Texture="_diffringglow.png";
			InitCommand=function(self) self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y+4):addx(icon_offset):diffuse(ColorLightTone(PlayerColor(pn)))
			end;
			OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) 
				self:spin():effectmagnitude(0,0,26)
			end;
		};
		LoadFont("StepsDisplayListRow meter") .. {
			InitCommand=function(self)
				self:diffuse(BoostColor((ColorLightTone(PlayerColor(pn))),1.9)):horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y):addx(icon_offset):maxwidth(50)
			end;
			OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) end;			
			["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:queuecommand("Set") end;
			  SetCommand=function(self)
				if GAMESTATE:GetCurrentSong() then if GAMESTATE:GetCurrentSteps(pn) ~= nil then
					self:settext(GAMESTATE:GetCurrentSteps(pn):GetMeter())
				end
				else self:settext("") end;
				end;
			};
		LoadFont("Common normal") .. {
			InitCommand=function(self)
				self:diffuse(BoostColor((ColorLightTone(PlayerColor(pn))),1.9)):horizalign(center):x(SCREEN_CENTER_X+165)
				:y(SCREEN_CENTER_Y-6+70):addx(icon_offset):zoom(0.5):maxwidth(150/0.5)
			end;
			OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) end;			
			["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self)
			 local steps_data = GAMESTATE:GetCurrentSteps(pn)
				if steps_data ~= nil then
					local rd = GAMESTATE:GetCurrentSteps(pn):GetRadarValues(pn);
					local p_taps = rd:GetValue('RadarCategory_TapsAndHolds')+rd:GetValue('RadarCategory_Jumps')+rd:GetValue('RadarCategory_Hands');
					self:settext(p_taps .. " notes");
				else
					self:settext("")
				end
			 end
			};
		};
else
	-- Course version
	t[#t+1] = StandardDecorationFromTable("PercentScore"..ToEnumShortString(pn), PercentScore(pn));	
	t[#t+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:visible(GAMESTATE:IsHumanPlayer(pn))
		end;
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == (pn) then
				self:visible(true):diffusealpha(0):decelerate(0.2):diffusealpha(1)
			end;
		end;
		OffCommand=function(self) self:decelerate(0.6):addx(SCREEN_WIDTH) end;
		---
		Def.Sprite {
			Texture="_diffring.png";
			InitCommand=function(self) self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y+4):addx(icon_offset)
			end;
			OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) 
				self:spin():effectmagnitude(0,0,26)
			end;
			["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:queuecommand("Set") end; 
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentCourse()
				local stepsData = GAMESTATE:GetCurrentTrail(pn)
				if song then 
					if stepsData ~= nil then
						local cd = GetCustomDifficulty(stepsData:GetStepsType(), stepsData:GetDifficulty(), song:GetCourseType());
						self:diffuse(CustomDifficultyToColor(cd))
					end
				end
			end;
		};		
		Def.Sprite {
			Texture="_diffringglow.png";
			InitCommand=function(self) self:horizalign(center):x(SCREEN_CENTER_X+165):y(SCREEN_CENTER_Y+4):addx(icon_offset)
			end;
			OnCommand=function(self) self:addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) 
				self:spin():effectmagnitude(0,0,26)
			end;
			["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:queuecommand("Set") end; 
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentCourse()
				local stepsData = GAMESTATE:GetCurrentTrail(pn)
				if song then 
					if stepsData ~= nil then
						local cd = GetCustomDifficulty(stepsData:GetStepsType(), stepsData:GetDifficulty(), song:GetCourseType());
						self:diffuse(CustomDifficultyToColor(cd))
					end
				end
			end;
		};
		LoadFont("Common Normal") .. {
			InitCommand=function(self)
				self:diffuse(BoostColor((ColorLightTone(PlayerColor(pn))),1.3)):horizalign(center):x(SCREEN_CENTER_X+165)
				:y(SCREEN_CENTER_Y+2):addx(icon_offset):zoom(0.75):maxwidth(150/0.75)
			end;
			OnCommand=function(self) self:queuecommand("Set"):addx(SCREEN_WIDTH):decelerate(0.6):addx(-SCREEN_WIDTH) end;			
			["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:queuecommand("Set") end; 
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == pn then
					self:queuecommand("Set"):diffusealpha(0):smooth(0.3):diffusealpha(1) 
				end;
			end;
			ChangedLanguageDisplayMessageCommand=function(self) self:queuecommand("Set") end;
			SetCommand=function(self)
				local song = GAMESTATE:GetCurrentCourse()
				local stepsData = GAMESTATE:GetCurrentTrail(pn)
				if song then 
					if stepsData ~= nil then
						local st = stepsData:GetStepsType();
						local diff = stepsData:GetDifficulty();
						local courseType = GAMESTATE:IsCourseMode() and song:GetCourseType() or nil;
						local cd = GetCustomDifficulty(st, diff, courseType);
						self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)))
					else
						self:settext("")
					end
				else
					self:settext("")
				end
			  end
		};
		};
end;
end;

return t